/*
 * Decompiled with CFR 0.152.
 */
package org.gambleaddon.autogamble.client.util;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class WebhookUtil {
    private static final HttpClient httpClient = HttpClient.newHttpClient();

    public static void sendWebhook(String url, String jsonPayload) {
        new Thread(() -> {
            try {
                WebhookUtil.log("Sending webhook... (payload length: " + jsonPayload.length() + ")");
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload, StandardCharsets.UTF_8)).build();
                HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                int status = response.statusCode();
                WebhookUtil.log("Webhook response: HTTP " + status);
                if (status >= 400) {
                    System.err.println("[AutoGamble] Webhook failed \u2013 status: " + status);
                    System.err.println("[AutoGamble] Response body: " + response.body());
                } else {
                    WebhookUtil.log("Webhook successfully sent");
                }
            }
            catch (Exception e) {
                System.err.println("[AutoGamble] Webhook execution failed:");
                e.printStackTrace();
            }
        }).start();
    }

    private static void log(String msg) {
        System.out.println("[WebhookUtil] " + msg);
    }
}

